library pack1076;
use pack1076.pack1076.all;


entity LPMCMP8 is port (
   signal AEB: out vlbit;
   signal DataA, DataB: in vlbit_vector (7 downto 0));
end LPMCMP8;

architecture lpm of LPMCMP8 is
   signal int_aneb: vlbit;

begin
   -- Equality only
   int_aneb <=
      (DataA (7) xor DataB (7)) or
      (DataA (6) xor DataB (6)) or
      (DataA (5) xor DataB (5)) or
      (DataA (4) xor DataB (4)) or
      (DataA (3) xor DataB (3)) or
      (DataA (2) xor DataB (2)) or
      (DataA (1) xor DataB (1)) or
      (DataA (0) xor DataB (0));

   -- Assign outputs
   AEB <= not (int_aneb) after 0 ns;
end lpm;
